% This function is for survival analysis on Leave-One-Out
% read in clinical data for patients
%% Define a colormap (To run survivals uncomment: statistical_analyses_gastric_cancer)
close;
[LOU_ColorMap, LOUT_colstr] = MyColorMap(LOUT_nr_comps); 
 plots_dir = pwd;
 colmap = jet; close;
 LOUT_RGB_COLORS_OfClusters = colmap(LOU_ColorMap,:)*255
%%
LOUT_clinical_data = Clinical_data;

% create dataset for agreement analysis results
LOUT_mva_data = dataset(LOUT_sample_to_component(:,1),LOUT_sample_to_component(:,2));

% %=====Walid Modifications======
% mva_data = dataset(sample_to_component(:,1),sample_to_component(:,2));

% join datasets
jdata = join(LOUT_clinical_data, LOUT_mva_data, 'LeftKeys', 'Sample_ID',  'Rightkeys', 'Var1', 'Type', 'inner');
jdata.Surv = jdata.Surv_time/(365.25/12); % Convert days to months

export(jdata, 'file', strcat(plots_dir,'\', 'LOU_jdata_', num2str(LOUT_nr_comps), '.txt'))

%% Survival Analysis
%% 1st open and load library(rscproxy) in R!!!!
wdR = regexprep(plots_dir, '\\', '\\\');
openR;
evalR(['setwd("' wdR '")']);
evalR('library(survival)');

%% Survival analysis on components and assigned samples
putRdata('survtime',jdata.Surv_time);
putRdata('status',jdata.Surv_status);
putRdata('groups', jdata.Var2);
evalR('survobj <- Surv(survtime, as.integer(status))');
%evalR(['plot(survfit(survobj ~ groups), col=1:' num2str(length(unique(jdata.Var2))) ')']);
evalR('fit <- survfit(survobj ~ as.factor(groups))');
evalR('sdiff <- survdiff(survobj ~ as.factor(groups))');
evalR('pvalue <- as.numeric(format(signif(1 - pchisq(sdiff$chisq,length(sdiff$n)-1),3)))');
pvalue = getRdata('pvalue');
disp(pvalue);
evalR(['png("LOUT_KM_plot_k_' num2str(LOUT_nr_comps) '.png")']);
%evalR(['postscript("0_KM_plot_k_' num2str(nr_of_components) '.eps")']);
evalR(['plot(fit, col=' LOUT_colstr ', lwd=2)']);
evalR(['legend("topright", as.character(sort(unique(groups))), col=' LOUT_colstr ', lty=1)']);
evalR('legend("bottomleft", paste("p =", pvalue))');
evalR('dev.off()');